//
var STATES_ARR = ['up','over','down','selected','disabled'];
var LAYER_LABELS = ['States', 'Labels', 'Code','Instructions'];

var instructions = {}
var componentHash = {};
					
var libraryItems;
var libraryHash = {};
var version = getVersion();
var isComplete = false;
var framesAdded = 10;
//function scaleformCreator(p_type,p_override) {
/**
*	This method is called when component is selected inside of the list
*	and create button is clicked, the function takes in the selected components label,linkage,button states,instructions,override[optional].
*	Components can be create by selecting a sprite on stage or a selected sprite in the library.
*	This function creates your components timeline,layers and instructions layer. You can add  more frame spacing by increasing the "framesAdded" variable
*
**/
function scaleformCreator(p_label,p_className,p_states,p_instructions,p_override) {
	
	fl.outputPanel.clear();
	p_label = unescape(p_label);
	p_className = unescape(p_className);
	p_states = unescape(p_states);
	p_instructions = unescape(p_instructions);
	p_override = unescape(p_override);
			 
	// create states array
	var states = p_states.split("|");
	
	var currDom = fl.getDocumentDOM();
	
	var errorList = [];
	
	if (!currDom.selection.length && !currDom.library.getSelectedItems().length) {
		alert('Please select a movieclip from the stage or library.');
		return;
	}
	var items = (currDom.selection!=0) ? currDom.selection : currDom.library.getSelectedItems();
	//SD:Check if its from stage or library 
	var from = (currDom.selection!=0) ? 'stage' : 'lib';
	
	for (i=0;i<items.length;i++) {
		var mov = items[i];
		if (mov.symbolType) {
			if (mov.symbolType != 'movie clip') { errorList.push('Item '+mov.libraryItem.name+' is not a Movie Clip.');}
		}
	}
	if (errorList.length == items.length) {
		alert('Please convert to a movieclip first.')
		//fl.trace('Error(s), have happened, operation stopped: \n\t\t' + errorList.join('\n\t\t'));
		return;
	}
	
	var errorList = [];
	var successList = [];
	var created
	for (i=0;i<items.length;i++) {
		mov = items[i];
		if (from == 'lib') { 
			//SD:maybe not the best way of doing this but... need to get an instance of the library symbol.
			created = currDom.library.addItemToDocument({x:-0,y:-0});
			mov = currDom.selection[0];
			currDom.deleteSelection();
		}
		if (mov.libraryItem) {
			if (mov.libraryItem.itemType) {
				//fl.trace(mov.libraryItem.itemType)
				if (mov.libraryItem.itemType != 'movie clip' && mov.libraryItem.itemType != 'component' ) {
					dispName = mov.libraryItem.name;
					errorList.push('Item '+ dispName +' is not an MovieClip.');
					continue;
				}
			}
		} else {
			continue;
		}
		
		var currTimeline = mov.libraryItem.timeline;
		libraryItems = currDom.library.items;
		var lib_length = libraryItems.length;
		for(var i=0;i<lib_length;i++) {
			libraryHash[libraryItems[i].linkageIdentifier] = libraryItems[i].linkageIdentifier;
		}
		
		if (mov.libraryItem.linkageClassName) {
			if (mov.libraryItem.linkageIdentifier == libraryHash[mov.libraryItem.linkageIdentifier] && p_override == undefined) {
				dispName = (mov.name)?mov.name:'(libraryItem)'+mov.libraryItem.name;
				errorList.push(dispName + ' has already been converted.');
				continue;
			}
		}
		//
		if (currTimeline.layers[0].name == 'Instructions' || currTimeline.layers[0].name == 'Code' ) {
			if (from == 'stage') { currDom.enterEditMode('inPlace'); }
			if (from == 'lib') { currDom.library.editItem(); }
			return;
		}
		currTimeline.layers[0].name = LAYER_LABELS[0];
		
		for (b=1;b<LAYER_LABELS.length;b++) {
			currTimeline.addNewLayer(LAYER_LABELS[b],'normal',true);
		}		
		

		currTimeline.insertFrames((states.length*framesAdded),true,0);
		
		//First frame
		currTimeline.layers[2].frames[0].name = states[0];
		
		currTimeline.layers[0].frames[0].name = 'See instructions in actions panel';
		currTimeline.layers[0].frames[0].labelType = 'comment';
		
		
		//Middle frames
		for (b=1;b<states.length;b++) {
			currFrame = b*framesAdded;
			//
			currTimeline.currentLayer = 1;
			currTimeline.insertKeyframe(currFrame-1);
			currTimeline.layers[1].frames[currFrame].actionScript = 'stop();'
			//
			currTimeline.currentLayer = 2;
			currTimeline.insertKeyframe(currFrame);
			//
			currTimeline.layers[2].frames[currFrame].name = states[b];			
			
		}
		
		s_instructions = new String(p_instructions);
		s_instructions.replace(/^\s*/,"").replace(/\s*$/,"");
		currTimeline.layers[0].frames[0].actionScript = "/**\n"+ s_instructions+"\n**/";
		
		//Last Frame
		currTimeline.currentLayer = 1;
		currTimeline.insertKeyframe(states.length*framesAdded);
		currTimeline.layers[1].frames[states.length*framesAdded].actionScript = 'stop();';
		
		//SD: Removes last frame for all layers
		for(var j=3;j>=0;j--) {
			currTimeline.currentLayer = j;
			currTimeline.removeFrames(states.length*framesAdded,states.length*framesAdded-1);
		}
							 
		mov.libraryItem.linkageExportForAS = true;
		mov.libraryItem.linkageExportInFirstFrame = true;
		mov.libraryItem.linkageClassName = p_className;
		mov.libraryItem.linkageIdentifier = mov.libraryItem.name.split('/').pop();
		if (!mov.libraryItem.linkageIdentifier) { 
			mov.libraryItem.linkageIdentifier = p_label;
		}
		
		dispName = (mov.name)?mov.name:'(libraryItem)'+mov.libraryItem.name;
		successList.push(dispName + ' has been converted to a Component -- ' + p_label+'.');
	}
	
	if (errorList.length) {
		var con = confirm(errorList.join('\n\t\t') + ' Would you like to override? **** Better Description needed ****');
		if (con) {
			scaleformCreator(p_label,true);
		}
	}
	if (successList.length) {
		if (from == 'stage') { currDom.enterEditMode('inPlace'); }
		if (from == 'lib') { currDom.library.editItem(); }
	}
	currDom.selectNone();
	currDom.library.selectItem('');
}

function readXML(langname) {
	//SD: Read in XML from en_.xml file located in configuration folder (ScaleForm/Locale)
	// returns the contents from file and is parsed inside flash
	var path = fl.configURI+'Scaleform/locale/'+langname+'/creator.xml';
	var content = FLfile.read(path);
	return content;
	
}

function convertURI(p_path) {
	var network = (p_path.substr(0,2) == "\\\\"); // Does path start with "\\"?
	if (version.mac && version.major == "7") {
		//fl.trace("Platform Mac 7");
		var fst = "file:///";
		var div = ":";
	} else if (version.mac) { // Sort of a URI, but without a "file://"
		//fl.trace(" > Platform: Mac 8+");
		var fst = "file://";
		var div = "/";
	} else if (network) {
		//fl.trace(" > Platform: Win Network");
		var fst = "file://";
		var div = "\\";
	} else { // Windows ALWAYS uses a windows path...
		//fl.trace(" > Platform: Win Local 7");
		var fst = "file:///"
		var div = "\\";
		p_path.split(":").join("|")
	}
	var path = p_path.substr(0, p_path.lastIndexOf(div)+1);
	path = fst + path.split(div).join("/");
	return path;
}

function getVersion() {
	var ver = fl.version;
	var pieces = ver.split(",");
	var plat = pieces[0].split(" ");
	return {
		platform: plat[0],
		windows: (plat[0] == "WIN"),
		mac: (plat[0] == "MAC"),
		major: plat[1],
		minor: pieces[1],
		revision: pieces[2],
		build: pieces[3]
	};
}